/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.crafting.feature.RottenFleshBlock;
import svenhjol.meson.MesonBlock;

public class BlockRottenFlesh
extends MesonBlock {
    protected static List<IBlockState> transformables = new ArrayList<IBlockState>(){
        {
            this.add(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
            this.add(Blocks.field_150349_c.func_176223_P());
            this.add(Blocks.field_185774_da.func_176223_P());
        }
    };
    protected static IBlockState podzol = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
    protected static IBlockState mycelium = Blocks.field_150391_bh.func_176223_P();

    public BlockRottenFlesh() {
        super(Material.field_151583_m, "rotten_flesh_block");
        this.func_149711_c(RottenFleshBlock.hardness);
        this.func_149752_b(RottenFleshBlock.resistance);
        this.setHarvestLevel("sword", RottenFleshBlock.harvestLevel);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K) {
            if (!RottenFleshBlock.transformToPodzol && !RottenFleshBlock.transformToSoil) {
                return;
            }
            if (!world.func_175697_a(pos, 2)) {
                return;
            }
            ArrayList<IBlockState> transforms = new ArrayList<IBlockState>(Arrays.asList(podzol, mycelium));
            transforms.forEach(blockType -> {
                if (world.func_180495_p(pos) != blockType && world.func_180494_b((BlockPos)pos).field_76752_A == blockType && transformables.contains(world.func_180495_p(pos.func_177984_a()))) {
                    world.func_180501_a(pos.func_177984_a(), blockType, 2);
                }
            });
            if (RottenFleshBlock.transformToSoil) {
                for (EnumFacing facing : EnumFacing.values()) {
                    if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != Blocks.field_150355_j) continue;
                    IBlockState transformTo = Blocks.field_150346_d.func_176223_P();
                    world.func_180501_a(pos, transformTo, 2);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (RottenFleshBlock.showParticles && rand.nextInt(10) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

